;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: QP1INV.asm
;;   Version: 1.3, Updated on 2004/07/19 at 16:36:03
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: DigInv User Module software implementation file
;;               for CY8C22/24/27/29xxx and related devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "QP1INV.inc"
include "memory.inc"


;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export   QP1INV_EnableInt
export  _QP1INV_EnableInt
export   QP1INV_DisableInt
export  _QP1INV_DisableInt
export   QP1INV_Start
export  _QP1INV_Start
export   QP1INV_Stop
export  _QP1INV_Stop

;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
bfCONTROL_REG_START_BIT:   equ   1     ; Control register start bit

area UserModules (ROM, REL)

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: QP1INV_EnableInt
;
;  DESCRIPTION:
;     Enables this receiver's interrupt by setting the interrupt enable mask
;     bit associated with this User Module. Remember to call the global interrupt
;     enable function by using the macro: M8C_EnableGInt.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 QP1INV_EnableInt:
_QP1INV_EnableInt:
   RAM_PROLOGUE RAM_USE_CLASS_1
   M8C_EnableIntMask QP1INV_INT_REG, QP1INV_bINT_MASK
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: QP1INV_DisableInt
;
;  DESCRIPTION:
;     Disables this RX8's interrupt by clearing the interrupt enable mask bit
;     associated with this User Module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 QP1INV_DisableInt:
_QP1INV_DisableInt:
   RAM_PROLOGUE RAM_USE_CLASS_1
   M8C_DisableIntMask QP1INV_INT_REG, QP1INV_bINT_MASK
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: QP1INV_Start
;
;  DESCRIPTION:
;     Sets the start bit in the Control register of this user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
;  THEORY of OPERATION or PROCEDURE:
;
;     1) Save the Interrupt register
;     2) Save the Output register
;     3) Save the input register
;     4) Switch the output to Disabled - LOW
;     5) Disable Interrupt
;     6) Start the DigInv
;     7) Re-instate the input source
;     8) Re-instate the output
;     9) Re-instate the Interrupt register
;-----------------------------------------------------------------------------
 QP1INV_Start:
_QP1INV_Start:
   RAM_PROLOGUE RAM_USE_CLASS_1
   push  A

   ; The DigInv must see a positive clock edge in order to "start" itself
   ; in the correct state.  Once it sees a clock edge, it will follow its
   ; input source.  To do this, we disable outputs, switch the input source
   ; to the 48MHz clock, start the DigInv, re-instate the user's input source
   ; and then re-instate the output.

   ; disable the interrupt
   mov   A, REG[QP1INV_INT_REG]
   push  A

   M8C_DisableIntMask QP1INV_INT_REG, QP1INV_bINT_MASK

   M8C_SetBank1
   ; set the output to disable - will remain low!
   mov   A, REG[QP1INV_OUTPUT_REG]
   push  A

   mov   REG[QP1INV_OUTPUT_REG], 0

   ; set the input to the 48MHz clock
   mov   A, REG[QP1INV_INPUT_REG]
   push  A

   mov   REG[QP1INV_INPUT_REG], 04

   M8C_SetBank0
   ; start the inverter
   or    REG[QP1INV_CONTROL_REG], bfCONTROL_REG_START_BIT

   ; Re-instate the input
   M8C_SetBank1
   pop   A
   mov   REG[QP1INV_INPUT_REG], A

   ; Re-instate the output
   pop   A
   mov   REG[QP1INV_OUTPUT_REG], A
   M8C_SetBank0

   ;clear interrupt
   and   REG[INT_CLR1], ~QP1INV_bINT_MASK

   ; Re-instate the interrupt state
   pop   A
   mov   REG[QP1INV_INT_REG], A

   ;Done!
   pop   A
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: QP1INV_Stop
;
;  DESCRIPTION:
;     Halts operation of the Digital Inverter.  Output is set LOW.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 QP1INV_Stop:
_QP1INV_Stop:

   RAM_PROLOGUE RAM_USE_CLASS_1
   and   REG[QP1INV_CONTROL_REG], ~bfCONTROL_REG_START_BIT
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret

.ENDSECTION

; End of File QP1INV.asm



